//
//  BPMirrorSyncDaemon.h
//  BPMirrord
//
//  Created by Brent Gulanowski on 10-02-23.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCClientServer/MCMirrorSyncDaemon.h>


@interface BPMirrorSyncDaemon : MCMirrorSyncDaemon {
    BOOL wantsRowCountIntegrityCheck;
    id appDelegate;
}

@property (assign) id appDelegate;
@property BOOL wantsRowCountIntegrityCheck;
/*!
 We have our own subclass to handle some specific Billings cases (cached values and invoicing while timing on another device).
 */
- (MCReplicaClient *)instantiateReplicaClient;

@end

@interface NSObject (BPMirrorSyncDaemonAppDelegate)
- (void)syncDaemonEncounteredExitError:(BPMirrorSyncDaemon *)daemon;

// We need to know if the main BP app is running. If so, we need to defer the wipe command to the app itself. We only do the delete ourselves if the app is not running. It is the delegate's responsibility to do the delete
- (void)syncDaemon:(BPMirrorSyncDaemon *)daemon requiresActionForAuthorizationCode:(MCSAuthorizationResultCode)authCode;
@end